/****** Object:  StoredProcedure [dbo].[usp_Get_Movement_Request]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Get_Movement_Request]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Get_Movement_Request]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		PII	
-- Create date: 24.10.2012
-- Description:	Get movement request by ID.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Get_Movement_Request] 
	@ID	INT = NULL,
	@DOMAIN_ID VARCHAR(50) = NULL
AS
BEGIN
SET NOCOUNT ON

	DECLARE @FACILITY_LIST VARCHAR(MAX)
	SET @FACILITY_LIST = ''
    -- GET THE LIST OF FACILITIES
	DECLARE @I INT, @ROWCOUNT INT							
	CREATE TABLE #FACILITIES (ID INT, FACILITY_UID UNIQUEIDENTIFIER)

	INSERT INTO #FACILITIES(ID, FACILITY_UID)
	SELECT ROW_NUMBER() OVER (ORDER BY FACILITY_UID), FACILITY_UID 
	FROM ORDER_FACILITY
	WHERE ORDER_ID = @ID AND ORDER_TYPE ='TRA'
	SET @ROWCOUNT = @@ROWCOUNT

	SET @I = 1
	SET @FACILITY_LIST = COALESCE(@FACILITY_LIST,'')
	WHILE (@I <= @ROWCOUNT)
		BEGIN
			SELECT @FACILITY_LIST = @FACILITY_LIST + CAST(FACILITY_UID AS VARCHAR(50)) + ',' FROM #FACILITIES WHERE ID = @I
			SET @I = @I + 1
		END

	DROP TABLE #FACILITIES

	SELECT
		[ID],
		[DOMAIN_ID],
		[IEN],
		[PATIENT_UID],
		[ORDERED_DATE],
		[IS_ACTIVE],
		[SIGNED_BY_UID],
		[SIGNED_DATE],
		[RELEASED_DATE],
		[PROVIDER_UID],
		[VISTA_SITE_UID],
		[HOSPITAL_LOCATION_UID],
		[WARD_UID],
		[ORDER_TEXT],
		@FACILITY_LIST AS [FACILITY_LIST]
	FROM MOVEMENT_REQ 	
	WHERE ID = @ID AND DOMAIN_ID = @DOMAIN_ID

END
GO
